#ifndef ZMODELER_STRUCT_VERTTBL_H_INCLUDED
#define ZMODELER_STRUCT_VERTTBL_H_INCLUDED

class DllExport tVertexTable
{
public:
//------------------------
//  data members
  long      VertAmount;
  tNormalVertex DummyVert;
  tNormalVertex  *Table;

//------------------------
//  construction/deconstruction
  tVertexTable();
  tVertexTable(int amount);
  ~tVertexTable();

//------------------------
//  functions
  void Init(int amount, BOOL release=FALSE);//creates empty Table
  tNormalVertex*  DuplicateTable();  //returns duplicate of Table

  void AddVertex(tPOINT p);  //adds single vertex to the Table
  void AddVertex(tPOINT p, DWORD col);  //adds single vertex to the Table
  void AddVertex(float px, float py, float pz);  //adds single vertex to the Table
  void AddVertex(float px, float py, float pz, DWORD col);  //adds single vertex to the Table
  void DeleteVertex(long index);  //Deletes single vertex
  //Deletes multple vertices (marked, selected, hidden)
  void DeleteVertices(BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden);

  void ToHasFlagSetFlag(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
              BOOL HasntMark, BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
              BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  void ToHasFlagChangeFlag(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
                BOOL HasntMark, BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
                BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  void ToAllChangeFlag(  BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  BOOL Selected(long index);  //tells whether the custom face has Z3D_FLAG_SELECTED in nFlags
  BOOL Marked(long index);  //tells whether the custom face has Z3D_FLAG_MARKED in nFlags
  BOOL Disabled(long index);  //tells whether the custom face has Z3D_FLAG_DISABLED in nFlags
  BOOL Hidden(long index);  //tells whether the custom face has Z3D_FLAG_HIDDEN in nFlags
  void Select(long index);  //selects one face
  void UnSelect(long index);  //deselects one face
  void Mark(long index);    //marks one face
  void UnMark(long index);  //unmarks one face
  void Disable(long index);  //disables one face
  void Enable(long index);  //enables one face
  void Hide(long index);    //hides one face
  void UnHide(long index);  //un-hides one face
  void SelectAll();      //selects all faces in Table
  void UnSelectAll();      //deselects all faces in Table
  void MarkAll();        //marks all faces in Table
  void UnMarkAll();      //unmarks all faces in Table
  void DisableAll();      //disables all faces in Table
  void EnableAll();      //enables all faces in Table
  void HideAll();        //hides all faces in Table
  void UnHideAll();      //unhides all faces in Table

  tNormalVertex& Get(int index);//safe access to Table elements
};

#endif

